﻿//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================
using Qiyu.Sdk.Platform;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class QiyuDLCTest : MonoBehaviour
{
    const string TAG = "QiyuDLCTest";
    public Text textField;
    public Dropdown dropdown_sku;

    private void Start()
    {
        //Need init first when use other pay API.
        QiyuDLC.Init(QiyuMessage.GetRequestResult<QiyuMessage.SDKInit>((msg) =>
        {
            if (msg.IsSuccess())
            {
                Debug.Log(TAG + $" InitQiyuDLC OK!");
                textField.text = $"InitQiyuDLC OK!";
            }
            else
            {
                Debug.Log(TAG + $" InitQiyuDLC Failed! code:{msg.code}");
                textField.text = $"InitQiyuDLC Failed! code:{msg.code}";
            }
        }));

        dropdown_sku.ClearOptions();
        dropdown_sku.options.Add(new Dropdown.OptionData("sku_test"));
        dropdown_sku.RefreshShownValue();
    }

    public void OnClickButton(GameObject btn)
    {
        if (btn.name == "BackToSample")
        {
            SceneManager.LoadScene("PlatformTest");
        }
        else if (btn.name == "GetAssetsList")
        {
            string text = "";
            QiyuDLC.GetAssetsList(QiyuMessage.GetRequestResult<QiyuMessage.QiyuDlcAssetDetails>((msg) =>
            {
                Debug.Log(TAG + $" GetAssetsList code:{msg.code},count:{msg.data?.count}");
                if (msg.IsSuccess() && msg.data != null)
                {
                    dropdown_sku.ClearOptions();
                    foreach (var info in msg.data.items)
                    {
                        text += info.ToString() + "\n";
                        dropdown_sku.options.Add(new Dropdown.OptionData(info.sku));
                    }
                    dropdown_sku.RefreshShownValue();
                    textField.text = $"GetAssetsList->\n{text}";
                    Debug.Log(TAG + " GetAssetsList->\n" + text);
                }
                else
                {
                    textField.text = $"GetAssetsList Error:{msg.code}-{msg.message}";
                }
            }));
        }
        else if (btn.name == "GetAssetStatus")
        {
            QiyuDLC.GetAssetStatus(QiyuMessage.GetRequestResult<QiyuMessage.QiyuDlcAssetStatus>((msg) =>
            {
                Debug.Log(TAG + $" GetAssetStatus code:{msg.code},orderId:{msg.data}");
                if (msg.IsSuccess())
                {
                    textField.text = $"GetAssetStatus->\n{msg.data}";
                    Debug.Log(TAG + $" GetAssetStatus->\n{msg.data}");
                    if (msg.data.downloadStatus == QiyuMessage.QiyuDlcAssetStatus.DOWNLOAD_STATUS_AVAILABLE)
                    {
                        //Availiable! Start to download
                    }
                    else if (msg.data.downloadStatus == QiyuMessage.QiyuDlcAssetStatus.DOWNLOAD_STATUS_DOWNLOADING)
                    {
                        //Download is not complete, Need continue
                    }
                    else if (msg.data.downloadStatus == QiyuMessage.QiyuDlcAssetStatus.DOWNLOAD_STATUS_COMPLETE)
                    {
                        //Download is completed, Use msg.data.filePath to load asset
                    }
                }
                else
                {
                    textField.text = $"GetAssetStatus Error:{msg.code}-{msg.message}";
                }
            }), dropdown_sku.options[dropdown_sku.value].text);
        }
        else if (btn.name == "DownloadAsset")
        {
            QiyuDLC.SetDownloadUpdateCallBack((progress) =>
            {
                textField.text = $"DownloadAsset progress:{progress}";
                Debug.Log($" DownloadAsset progress:{progress}");
                if (progress.code == QiyuMessage.QiyuDlcNotifications.CODE_COMPLETE)
                {
                    //Save to other path or load asset directly
                    textField.text = $"Asset download complete:{progress.filePath}";
                    Debug.Log($" Asset download complete:{progress.filePath}");
                }
            });
            QiyuDLC.DownloadAsset(QiyuMessage.GetRequestResult<string>((msg) =>
            {
                Debug.Log(TAG + " DownloadAsset " + msg);
                if (!msg.IsSuccess())
                {
                    textField.text = $"DownloadAsset Error:{msg.code}-{msg.message}";
                }
            }), dropdown_sku.options[dropdown_sku.value].text);
        }
    }
}
